//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3
import QtQuick.Dialogs  1.1

import wesual.Controls  1.0
import wesual.Create    1.0

import wesual.data.Core 1.0

Item {
    id : imageSourcePicker

    property Item       mediaDialog     // dialog object after creation
    property Document   document        // document for factory context
    property Item       parentItem      // parent item of picker for drag zone

    property bool       selectMultiple  : false
    property alias      popupVisible    : dropDown.popupVisible
    property alias      dropDownButton  : dropDown.dropdownButton
    property bool       removeWithNullSelection  : false

    signal resultingImages(var images)

    function show() {
        dropDown.show();
    }

    Connections {
        target : mediaDialog
        ignoreUnknownSignals : true
        onAccepted : {
            document.beginRecordChanges();
            imageSourcePicker.resultingImages(result);
            document.endRecordChanges();
        }
    }

    Component.onCompleted : {
        var dialogComponent = Qt.createComponent(
                    "qrc:/showcase/components/GlobalDialogComponent.qml");
        if(dialogComponent) {
            mediaDialog = dialogComponent.createObject(imageSourcePicker,
                        { "properties" : { "selectMultiple" : selectMultiple,
                                           "mediaTypes" : ["asset:image"]}});
        }
    }

    FileDialog {
        id: fileDialog

        property string fileDescription : qsTrId("44c6fe815035707e");

        title: qsTrId("64146504ed1b4116")
        nameFilters : {
            var formats = importer.fileExtensionsForType("asset:image");
            var filter = fileDescription + " (";
            for (var i = 0; i < formats.length; ++i) {
                filter += "*." + formats[i] + " ";
            }
            filter += ")";

            return [filter];
        }
        selectMultiple : imageSourcePicker.selectMultiple

        onAccepted : {
            importer.importFiles(fileDialog.fileUrls);
            fileDialog.close();
        }
        onRejected : fileDialog.close()
    }

    AssetImportDialog {
        id : importer

        context : Creator.context
        onAccepted : {
            document.beginRecordChanges();
            imageSourcePicker.resultingImages(result);
            document.endRecordChanges();
        }
    }

    Action {
        id : chooseAction
        text : qsTrId("b0c9b40beac986c7")
        onTriggered : mediaDialog.show();
        enabled : mediaDialog
    }

    Action {
        id : uploadAction
        text : qsTrId("bd97bfc9573142ac")
        onTriggered : fileDialog.open()
    }

    DropdownButtonPopup {
        id : dropDown
        actions : removeWithNullSelection
                  ? [chooseAction, uploadAction, removeAction]
                  : [chooseAction, uploadAction]
        onAccepted : {
            actions[result].trigger();
            dropDown.hide();
        }
    }
}

